# coding: windows-1252

import string
import sys, Tkinter, tkFont
import random
import codecs

# This program prints random entries from the SRS4g dictionary.  This
# is an effective way of proof-reading, and helps to avoid the situation
# where the a's are perfect, but the developer loses interest before he
# gets to the d's.

dict ='SRS4g.dict'
# The command line argument is the number of lines to display
n = int(sys.argv[1])
inp = codecs.open(dict, 'r', 'windows-1252')
lastrr = ''
lasteng = ''
lines = []

# Put the dictionary into the list lines.  Each entry is of the form
# trad-spelling: SRS-spelling 
for line in inp:
    line = line[:-2]
    parts = line.split('  - ')
    i = parts[1].find(' (')
    if i < 0: eng = parts[1]
    else: eng = parts[:i] 
    # Skip duplicate entries.  These occur because sometimes a word
    # will have two similar pronunciations which end up with the same 
    # SRS4g spelling (for instance, because the only difference is
    # stress).
    if eng == lasteng and parts[0] == lastrr: continue
    lasteng = eng
    lastrr = parts[0]
    lines.append(parts[1] + ': ' + parts[0] + '\n')

inp.close()

# A case-insensitive comparison
def icmp ( l1, l2 ):
    return cmp(l1.lower(), l2.lower())

# Build a list for display of n random entries from lines.  Sort them
# alphabetically.
def dobab ( ):
    outlines = []
    for i in xrange(n):
        outlines.append(random.choice(lines))
    outlines.sort(icmp)
    t.delete('1.0', Tkinter.END)
    # Add the lines to the screen display
    for i in xrange(n):
        t.insert(Tkinter.END, outlines[i])

# Set up the window layout: A title bar, the display lines, a scrollbar
# and two buttons
# The leading blank in the className keeps TK from lower-casing it
root = Tkinter.Tk(className=' SRS4g')
fr1 = Tkinter.Frame(root)
Tkinter.Label(fr1,text="Babbling").pack()
fn = 'Georgia'
f = tkFont.Font(family=fn, size=14)
sb = Tkinter.Scrollbar(fr1)
# There is room for 25 lines on the display without scrolling
t = Tkinter.Text(fr1, font=f, width=32, height=26)
sb.pack(side=Tkinter.RIGHT, fill=Tkinter.Y)
t.pack(side=Tkinter.LEFT, fill=Tkinter.Y)
sb.config(command=t.yview)
t.config(yscrollcommand=sb.set)

# generate the random lines
dobab()

fr1.pack(side=Tkinter.TOP)
f2 = tkFont.Font(size=11)
fr2 = Tkinter.Frame(root)

# The Exit button terminates execution
# The More button generates n more lines
Tkinter.Button(fr2, text="Exit", font=f2, command=root.quit).pack(side=Tkinter.RIGHT)
Tkinter.Button(fr2, text="More", font=f2, command=dobab).pack(side=Tkinter.LEFT)
fr2.pack(side=Tkinter.BOTTOM)

# Display lines until Exit is used or the window is closed
Tkinter.mainloop()
